VERSION 4.00
Begin VB.Form frmMain 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   Caption         =   "Synchronize Directories"
   ClientHeight    =   4800
   ClientLeft      =   2265
   ClientTop       =   1455
   ClientWidth     =   5295
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   0
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   5205
   HelpContextID   =   1
   Icon            =   "SD32Main.frx":0000
   Left            =   2205
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4800
   ScaleWidth      =   5295
   Top             =   1110
   Width           =   5415
   Begin VB.TextBox txtTrgtDir 
      Height          =   495
      HelpContextID   =   202
      Left            =   2760
      MultiLine       =   -1  'True
      ScrollBars      =   1  'Horizontal
      TabIndex        =   5
      Text            =   "SD32Main.frx":030A
      Top             =   360
      Width           =   2415
   End
   Begin VB.TextBox txtSrcDir 
      Height          =   495
      HelpContextID   =   201
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   1  'Horizontal
      TabIndex        =   2
      Text            =   "SD32Main.frx":0317
      Top             =   360
      Width           =   2415
   End
   Begin VB.TextBox txtIgnrType 
      Height          =   285
      HelpContextID   =   206
      Left            =   2760
      TabIndex        =   6
      Text            =   "txtIgnrType"
      Top             =   3240
      Width           =   2415
   End
   Begin VB.CheckBox chkCopyOld 
      Caption         =   " Copy older files"
      BeginProperty Font 
         name            =   "Arial"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   255
      HelpContextID   =   203
      Left            =   120
      TabIndex        =   7
      Top             =   3600
      Width           =   2415
   End
   Begin VB.CommandButton btnHelp 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "Help"
      Height          =   375
      Left            =   120
      TabIndex        =   10
      Top             =   4320
      Width           =   855
   End
   Begin VB.CheckBox chkSyncBoth 
      Caption         =   " Synchronize both ways"
      BeginProperty Font 
         name            =   "Arial"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   255
      HelpContextID   =   204
      Left            =   120
      TabIndex        =   8
      Top             =   3960
      Width           =   2415
   End
   Begin VB.CheckBox chkDelXtra 
      Caption         =   " Delete extra files"
      BeginProperty Font 
         name            =   "Arial"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   255
      HelpContextID   =   205
      Left            =   2760
      TabIndex        =   9
      Top             =   3960
      Width           =   2415
   End
   Begin VB.CommandButton btnExit 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Cancel          =   -1  'True
      Caption         =   "Exit"
      Height          =   375
      Left            =   4320
      TabIndex        =   12
      Top             =   4320
      Width           =   855
   End
   Begin VB.CommandButton btnSync 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "Synchronize"
      Default         =   -1  'True
      Height          =   375
      Left            =   1920
      TabIndex        =   11
      Top             =   4320
      Width           =   1455
   End
   Begin VB.DirListBox dirTrgt 
      Height          =   1605
      HelpContextID   =   202
      Left            =   2760
      TabIndex        =   3
      Top             =   960
      Width           =   2415
   End
   Begin VB.DirListBox dirSrc 
      Height          =   1605
      HelpContextID   =   201
      Left            =   120
      TabIndex        =   0
      Top             =   960
      Width           =   2415
   End
   Begin VB.DriveListBox drvTrgt 
      Height          =   315
      HelpContextID   =   202
      Left            =   2760
      TabIndex        =   4
      Top             =   2760
      Width           =   2415
   End
   Begin VB.DriveListBox drvSrc 
      Height          =   315
      HelpContextID   =   201
      Left            =   120
      TabIndex        =   1
      Top             =   2760
      Width           =   2415
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      Caption         =   "Ignore File Types:"
      BeginProperty Font 
         name            =   "Arial"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   15
      Top             =   3240
      Width           =   2535
   End
   Begin VB.Label Label2 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      Caption         =   "Target Directory:"
      BeginProperty Font 
         name            =   "Arial"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   2760
      TabIndex        =   14
      Top             =   120
      Width           =   1575
   End
   Begin VB.Label Label1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      Caption         =   "Source Directory:"
      BeginProperty Font 
         name            =   "Arial"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   120
      Width           =   1575
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' (32-bit version)

Option Explicit

Sub ValidateSourceDirectory()
    Dim sDir As String
    Dim bErr As Boolean
    Dim s As String
    
    bErr = False
    sDir = txtSrcDir.Text
        
    If sDir = "" Then
        sDir = gsCurrDir
        txtSrcDir.Text = sDir
    End If
    
    If Right$(sDir, 1) <> "\" Then
        sDir = sDir & "\"
    End If
        
    On Error Resume Next
        dirSrc.Path = sDir
        If Err.Number <> 0 Then
            bErr = True
        End If
    On Error GoTo 0
    
    If bErr Then
        Beep
        MsgBox "Not a valid source directory: """ & sDir & """", vbExclamation, "Directory Synchronization Utility"
        gbAutoSync = False  ' Make sure the form appears to the user
        
        dirSrc.BackColor = frmMain.BackColor
        drvSrc.BackColor = frmMain.BackColor
    
    ElseIf Left$(sDir, 2) = "\\" Then  ' Universal Naming Convention
        drvSrc.BackColor = frmMain.BackColor
    
    Else
        drvSrc.Enabled = False  ' Signal to avoid recursive change events
        drvSrc.Drive = Left$(dirSrc.Path, 1)
        drvSrc.Enabled = True
        
        dirSrc.BackColor = txtSrcDir.BackColor
        drvSrc.BackColor = txtSrcDir.BackColor
    End If
End Sub

Sub ValidateTargetDirectory()
    Dim sDir As String
    Dim bErr As Boolean
    Dim s As String
    
    bErr = False
    sDir = txtTrgtDir.Text
        
    If sDir = "" Then
        sDir = gsCurrDir
        txtTrgtDir.Text = sDir
    End If
    
    If Right$(sDir, 1) <> "\" Then
        sDir = sDir & "\"
    End If
        
    On Error Resume Next
        dirTrgt.Path = sDir
        If Err.Number <> 0 Then
            bErr = True
        End If
    On Error GoTo 0
    
    If bErr Then
        Beep
        MsgBox "Not a valid target directory: """ & sDir & """", vbExclamation, "Directory Synchronization Utility"
        gbAutoSync = False  ' Make sure the form appears to the user
        
        dirTrgt.BackColor = frmMain.BackColor
        drvTrgt.BackColor = frmMain.BackColor
    
    ElseIf Left$(sDir, 2) = "\\" Then  ' Universal Naming Convention
        drvTrgt.BackColor = frmMain.BackColor
    
    Else
        drvTrgt.Enabled = False  ' Signal to avoid recursive change events
        drvTrgt.Drive = Left$(dirTrgt.Path, 1)
        drvTrgt.Enabled = True
        
        dirTrgt.BackColor = txtTrgtDir.BackColor
        drvTrgt.BackColor = txtTrgtDir.BackColor
    End If
End Sub


Private Sub btnExit_Click()
    End  ' Stop program execution
End Sub

Private Sub btnHelp_Click()
    SendKeys "{F1}"
End Sub

Private Sub btnSync_Click()
    Dim sSrcDir As String    ' Source Directory
    Dim sTrgtDir As String   ' Target Directory
    Dim nSync As Long     ' # Files affected
    
    btnSync.Enabled = False

    Call InitializeLogText
    
    sSrcDir = txtSrcDir.Text
    sTrgtDir = txtTrgtDir.Text

    If UCase$(sSrcDir) = UCase$(sTrgtDir) Then
        nSync = 0
        Beep
        MsgBox "The source directory and target directory are the same: """ & sSrcDir & """", vbInformation, "Directory Synchronization Utility"
    Else
        nSync = nSynchronizeDirectories(gbCopyOld, gbDelXtra, sSrcDir, sTrgtDir, txtIgnrType)
        
        If gbSyncBoth Then  ' Sync. in opposite direction
            nSync = nSync + nSynchronizeDirectories(gbCopyOld, gbDelXtra, sTrgtDir, sSrcDir, txtIgnrType)
        End If
    End If
    
    If (gbNtfyUser Or (Not gbAutoSync)) And (nSync > 0) Then
        frmLog.Show  ' Will exit program when closed, if gbAutoSync is true
    ElseIf gbAutoSync Then
        Call ExecuteRunCommand
        End  ' Exit program
    End If

    btnSync.Enabled = True
End Sub

Private Sub chkCopyOld_Click()
    If chkCopyOld = vbChecked Then
        gbCopyOld = True
    Else
        gbCopyOld = False
    End If
End Sub

Private Sub chkDelXtra_Click()
    If chkDelXtra = vbChecked Then
        gbDelXtra = True
        chkSyncBoth = vbUnchecked  ' Cannot have both true
    Else
        gbDelXtra = False
    End If
End Sub

Private Sub chkSyncBoth_Click()
    If chkSyncBoth = vbChecked Then
        gbSyncBoth = True
        chkDelXtra = vbUnchecked  ' Cannot have both true
    Else
        gbSyncBoth = False
    End If
End Sub

Private Sub dirSrc_Change()
    Dim s As String
    
    s = dirSrc.Path
    txtSrcDir.Text = s
    
    If Left$(s, 2) = "\\" Then  ' Universal Naming Convention
        drvSrc.BackColor = frmMain.BackColor
    Else
        drvSrc.BackColor = txtSrcDir.BackColor
    End If
    
    dirSrc.BackColor = txtSrcDir.BackColor
End Sub

Private Sub dirTrgt_Change()
    Dim s As String
    
    s = dirTrgt.Path
    txtTrgtDir.Text = s
    
    If Left$(s, 2) = "\\" Then  ' Universal Naming Convention
        drvTrgt.BackColor = frmMain.BackColor
    Else
        drvTrgt.BackColor = txtTrgtDir.BackColor
    End If
    
    dirTrgt.BackColor = txtTrgtDir.BackColor
End Sub


Private Sub drvSrc_Change()
    If drvSrc.Enabled Then  ' Avoid recursive change events
        dirSrc.Path = Left$(drvSrc.Drive, 1) & ":"
    End If
End Sub

Private Sub drvTrgt_Change()
    If drvTrgt.Enabled Then  ' Avoid recursive change events
        dirTrgt.Path = Left$(drvTrgt.Drive, 1) & ":"
    End If
End Sub

Private Sub Form_Load()
    Dim s As String

    s = sInitializationEntry("Automatic", "NO")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        gbAutoSync = True
    Else
        gbAutoSync = False
    End If

    s = sInitializationEntry("NotifyUser", "YES")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        gbNtfyUser = True
    Else
        gbNtfyUser = False
    End If
    
    gsRunDir = sInitializationEntry("RunDirectory", "")
    gsRunCmd = sInitializationEntry("RunCommand", "")
    
    s = sInitializationEntry("SourceDirectory", "")
    If s = "" Then
        s = gsCurrDir
    ElseIf (InStr(s, ":") = 0) And (InStr(s, "\\") = 0) Then
        s = gsInitDrv & s
    End If
    txtSrcDir.Text = s
    Call ValidateSourceDirectory
    
    s = sInitializationEntry("TargetDirectory", "")
    If s = "" Then
        s = gsCurrDir
    ElseIf (InStr(s, ":") = 0) And (InStr(s, "\\") = 0) Then
        s = gsInitDrv & s
    End If
    txtTrgtDir.Text = s
    Call ValidateTargetDirectory

    s = sInitializationEntry("IgnoreFileTypes", "")
    txtIgnrType = s

    s = sInitializationEntry("CopyOlderFiles", "NO")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        gbCopyOld = True
        chkCopyOld = vbChecked
    Else
        gbCopyOld = False
        chkCopyOld = vbUnchecked
    End If

    s = sInitializationEntry("SynchronizeBothWays", "NO")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        gbSyncBoth = True
        chkSyncBoth = vbChecked
    Else
        gbSyncBoth = False
        chkSyncBoth = vbUnchecked
    End If

    s = sInitializationEntry("DeleteExtraFiles", "NO")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        If gbSyncBoth Then  ' Cannot both be true
            gbDelXtra = False
            chkDelXtra = vbUnchecked
            Beep
            MsgBox "Initialization setup error in file " & UCase$(gsInitFile) & ": SynchronizeBothWays and DeleteExtraFiles cannot both be enabled", vbExclamation, "Directory Synchronization Utility"
            gbAutoSync = False  ' Popup selection form due to error
        Else
            gbDelXtra = True
            chkDelXtra = vbChecked
        End If
    Else
        gbDelXtra = False
        chkDelXtra = vbUnchecked
    End If
                

    If gbAutoSync Then
        btnSync_Click
    Else
        Me.Show
    End If
End Sub



Private Sub txtSrcDir_LostFocus()
    Call ValidateSourceDirectory
End Sub

Private Sub txtTrgtDir_LostFocus()
    Call ValidateTargetDirectory
End Sub
